<?php

namespace App\Console\Commands;

use App\Models\Karyawan;
use App\Models\JatahCuti;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class UpdateMonthlyCuti extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cuti:update-bulanan';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Menambahkan 1 jatah cuti bulanan (feb-des)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $tahun = now()->year;

        DB::transaction(function () use ($tahun) {
            $karyawanAktif = Karyawan::where('status', 'aktif')->get();

            foreach ($karyawanAktif as $karyawan->id) {
                $jatah = JatahCuti::firstOrCreate(
                    [
                    'karyawan_id' => $karyawan->id,
                        'tahun' => $tahun
                    ],
                    [
                        'jatah' =>0
                    ]
                );
                // if ($jatah->jatah < 6) {
                // }
                $jatah->increment('jatah', 1);

            }

        });
            activity_log(
                'jatah_cuti',
                'generate',
                'Generate jatah cuti bulanan'
            );

        $this->info('Jatah cuti bulanan berhasil diperbarui');
    }
}
